/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayBoardTarget;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTarget;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.properties.EDisplayType;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.data.train.portable.StationDisplayData;
import de.mrjulsen.crn.event.ModCommonEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class AdvancedDisplayTarget
extends DisplayBoardTarget {
    private static boolean running = false;
    private static boolean threadRunning = false;
    private static final Queue<Runnable> workerTasks = new ConcurrentLinkedQueue<Runnable>();

    public static void start() {
        if (running) {
            AdvancedDisplayTarget.stop();
        }
        while (running && threadRunning) {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        workerTasks.clear();
        running = true;
        new Thread(() -> {
            threadRunning = true;
            CreateRailwaysNavigator.LOGGER.info("Advanced Display Data Manager has been started.");
            while (running) {
                while (!workerTasks.isEmpty()) {
                    try {
                        workerTasks.poll().run();
                    }
                    catch (Exception e) {
                        CreateRailwaysNavigator.LOGGER.info("Error while process Advanced Display Data. " + e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            workerTasks.clear();
            CreateRailwaysNavigator.LOGGER.info("Advanced Display Data Manager has been stopped.");
            threadRunning = false;
        }, "Advanced Display Data Manager").start();
    }

    public static void stop() {
        CreateRailwaysNavigator.LOGGER.info("Stopping Advanced Display Data Manager...");
        running = false;
    }

    private static void queueAdvancedDisplayWorkerTask(Runnable task) {
        workerTasks.add(task);
    }

    public void acceptFlapText(int line, List<List<MutableComponent>> text, DisplayLinkContext context) {
        CompoundTag nbt = context.sourceConfig();
        if (!nbt.m_128441_("AdvancedDisplay")) {
            return;
        }
        BlockEntity blockEntity = context.getTargetBlockEntity();
        if (blockEntity instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity blockEntity2 = (AdvancedDisplayBlockEntity)blockEntity;
            if (ModCommonEvents.hasServer()) {
                AdvancedDisplayBlockEntity controller = blockEntity2.getController();
                long dayTime = context.getTargetBlockEntity().m_58904_().m_46468_();
                AdvancedDisplayTarget.queueAdvancedDisplayWorkerTask(() -> {
                    if (controller != null && controller.getDisplayType().category().getSource() == EDisplayType.EDisplayTypeDataSource.PLATFORM) {
                        String filter = context.sourceConfig().m_128461_("Filter");
                        List<StationDisplayData> preds = AdvancedDisplayTarget.prepare(filter, controller.getDisplayProperties().platformDisplayTrainsCount().apply(controller));
                        controller.setDepartureData(preds, filter, GlobalSettings.getInstance().getOrCreateStationTagFor(filter).getInfoForStation(filter), dayTime);
                        ModCommonEvents.getCurrentServer().get().m_201446_(() -> ((AdvancedDisplayBlockEntity)controller).sendData());
                    }
                });
            }
        }
    }

    public static List<StationDisplayData> prepare(String filter, int maxLines) {
        ArrayList<StationDisplayData> result = new ArrayList<StationDisplayData>(maxLines);
        int i = 0;
        for (TrainStop stop : TrainUtils.getDeparturesAtStationName(filter, null)) {
            result.add(StationDisplayData.of(stop));
            if (++i < maxLines) continue;
            break;
        }
        return result;
    }

    public boolean isReserved(int line, BlockEntity target, DisplayLinkContext context) {
        return super.isReserved(line, target, context) || target instanceof AdvancedDisplayBlockEntity;
    }

    public DisplayTargetStats provideStats(DisplayLinkContext context) {
        AdvancedDisplayBlockEntity controller = this.getController(context);
        if (controller == null) {
            return new DisplayTargetStats(1, 1, (DisplayTarget)this);
        }
        return new DisplayTargetStats(1, 1, (DisplayTarget)this);
    }

    private AdvancedDisplayBlockEntity getController(DisplayLinkContext context) {
        BlockEntity teIn = context.getTargetBlockEntity();
        if (!(teIn instanceof AdvancedDisplayBlockEntity)) {
            return null;
        }
        AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)teIn;
        return be.getController();
    }

    public AABB getMultiblockBounds(LevelAccessor level, BlockPos pos) {
        AABB baseShape = super.getMultiblockBounds(level, pos);
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof AdvancedDisplayBlockEntity)) {
            return baseShape;
        }
        AdvancedDisplayBlockEntity fdbe = (AdvancedDisplayBlockEntity)be;
        AdvancedDisplayBlockEntity controller = fdbe.getController();
        if (controller == null) {
            return baseShape;
        }
        Vec3i normal = controller.getDirection().m_122427_().m_122436_();
        return baseShape.m_82338_(controller.m_58899_().m_121996_((Vec3i)pos)).m_82363_((double)(normal.m_123341_() * (controller.getXSize() - 1)), (double)(1 - controller.getYSize()), (double)(normal.m_123343_() * (controller.getXSize() - 1)));
    }
}

